
import 'package:peasmartcare/models/survey_choice_model.dart';

class SurveyQuestionModel {
  String id;
  String surveyId;
  String question;
  int type;
  List<SurveyChoiceModel> choiceList;

  SurveyQuestionModel({
    this.id,
    this.surveyId,
    this.question,
    this.type,
    this.choiceList,
  });

  factory SurveyQuestionModel.fromJson(Map<String, dynamic> json) => SurveyQuestionModel(
        id: json["SQD_Id"] ?? "",
        surveyId: json["SQ_Id"] ?? "",
        question: json["SQD_Question"] ?? "",
        type: json["SQD_Type"] ?? "",
        choiceList: List<SurveyChoiceModel>.from(json["SurveyQuestionChoice"].map((x) => SurveyChoiceModel.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "SQD_Id": id,
        "SQ_Id": surveyId,
        "SQD_Question": question,
        "SQD_Type": type,
        "SurveyQuestionChoice": List<dynamic>.from(choiceList.map((x) => x.toJson())),
      };
}
