class SurveyAnswerModel {
  String id;
  String questionId;
  String choiceId;
  String value;
  String customerId;
  String createBy;

  SurveyAnswerModel({
    this.id,
    this.questionId,
    this.choiceId,
    this.value,
    this.customerId,
    this.createBy,
  });

  factory SurveyAnswerModel.fromJson(Map<String, dynamic> json) => SurveyAnswerModel(
        id: json["SQ_Id"] ?? "",
        questionId: json["SQD_Id"] ?? "",
        choiceId: json["SQC_Id"] ?? "",
        value: json["SA_Answer1"] ?? "",
        customerId: json["customerId"] ?? "",
        createBy: json["CreateBy"] ?? "",
      );

  Map<String, dynamic> toJson() => {
        "SQ_Id": id,
        "SQD_Id": questionId,
        "SQC_Id": choiceId,
        "SA_Answer1": value,
        "customerId": customerId,
        "CreateBy": createBy,
      };
}
