class QuestionnaireAnswerModel {
  String questionId;
  String choiceId;
  String value;
  String customerId;

  QuestionnaireAnswerModel({
    this.questionId,
    this.choiceId,
    this.value,
    this.customerId,
  });

  factory QuestionnaireAnswerModel.fromJson(Map<String, dynamic> json) => QuestionnaireAnswerModel(
        questionId: json["RQD_Id"] ?? "",
        choiceId: json["RQC_Id"] ?? "",
        value: json["RA_Answer1"] ?? "",
        customerId: json["customerId"] ?? "",
      );

  Map<String, dynamic> toJson() => {
        "RQD_Id": questionId,
        "RQC_Id": choiceId,
        "RA_Answer1": value,
        "customerId": customerId,
      };
}
