class NotificationModel {
  String id;
  String customerId;
  String employeeId;
  String caNumber;
  String dateTime;
  String image;
  String detail;
  String name;
  String customerName;
  String type;
  String title;

  NotificationModel({
    this.id,
    this.customerId,
    this.employeeId,
    this.caNumber,
    this.dateTime,
    this.detail,
    this.name,
    this.customerName,
    this.type,
    this.title,
  });

  factory NotificationModel.fromJson(Map<String, dynamic> json) {
    return NotificationModel(
      id: json["NotificationID"] ?? "",
      customerId: json["customerId"] ?? "",
      employeeId: json["EmployeeID"] ?? "",
      caNumber: json["CA"] ?? "",
      dateTime: json["EventDate"] ?? "",
      detail: json["Detail"] ?? "",
      name: json["name"] ?? "",
      customerName: json["CustomerName"] ?? "",
      type: json["NotificationType"] ?? "",
      title: json["NotificationTitle"] ?? "",
    );
  }
  Map<String, dynamic> toJson() => {
        "NotificationID": id,
        "customerId": customerId,
        "EmployeeID": employeeId,
        "CA": caNumber,
        "EventDate": dateTime,
        "Detail": detail,
        "name": name,
        "CustomerName": customerName,
      };
}
