import 'dart:convert';

import 'package:html/parser.dart';

class NewsModel {
  String id;
  String subject;
  String typeName;
  String dateTime;
  String image;
  String detail;
  String detailBase64;
  bool isActive;

  NewsModel({
    this.id,
    this.subject,
    this.typeName,
    this.dateTime,
    this.image,
    this.detail,
    this.detailBase64,
    this.isActive,
  });

  factory NewsModel.fromJson(Map<String, dynamic> json) {
    var documentSubject = parse(json["N_Name"] ?? "");
    var documentDetail = parse(json["N_Detail"] ?? "");
    return NewsModel(
      id: json["N_Id"],
      subject: parse(documentSubject.body.text).documentElement.text,
      typeName: json["NG_Name"] ?? "",
      dateTime: json["strStartDate"],
      image: json["ImageFile"],
      // detail: parse(documentDetail.body.text).documentElement.text,
      detail: json["N_Detail"] ?? "",
      detailBase64: base64Encode(const Utf8Encoder().convert((json["N_Detail"] ?? ""))),
      isActive: json["IsAvtive"],
    );
  }
  Map<String, dynamic> toJson() => {
        "N_Id": id,
        "N_Name": subject,
        "NG_Name": typeName,
        "strStartDate": dateTime,
        "imaImageFilege": image,
        "N_Detail": detail,
        "IsAvtive": isActive,
      };
}
