import 'package:html/parser.dart' show parse;

class NewsFeaturedModel {
  String id;
  String subject;
  String image;
  String detail;

  NewsFeaturedModel({
    this.id,
    this.subject,
    this.image,
    this.detail,
  });

  factory NewsFeaturedModel.fromJson(Map<String, dynamic> json) {
    var documentSubject = parse(json["NF_Name"]??"");
    return NewsFeaturedModel(
        id: json["Id"],
        subject: parse(documentSubject.body.text).documentElement.text,
        image: json["ImageFile"],
        detail: json["NF_DETAIL"],
      );
  }

  Map<String, dynamic> toJson() => {
        "Id": id,
        "NF_Name": subject,
        "ImageFile": image,
        "NF_DETAIL": detail,
      };
}
