import 'package:peasmartcare/models/history_bill_detail_model.dart';

class HistoryBillModel {
  String amount;
  String paymentChannel;
  String dueDate;
  String paymentDate;
  String unitUsed;
  String billMonth;
  List<HistoryBillDetailModel> historyBillDetails;

  HistoryBillModel({
    this.amount,
    this.paymentChannel,
    this.dueDate,
    this.paymentDate,
    this.unitUsed,
    this.billMonth,
    this.historyBillDetails,
  });

  factory HistoryBillModel.fromJson(Map<String, dynamic> json) => HistoryBillModel(
        amount: json["Amount"].toString(),
        paymentChannel: json["PaymentChannel"],
        dueDate: json["DueDate"],
        paymentDate: json["PaymentDate"],
        unitUsed: json["UnitUsed"].toString(),
        billMonth: json["BillMonth"],
        historyBillDetails: List<HistoryBillDetailModel>.from(json["BillItemList"].map((x) => HistoryBillDetailModel.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "Amount": amount,
        "PaymentChannel": paymentChannel,
        "DueDate": dueDate,
        "PaymentDate": paymentDate,
        "UnitUsed": unitUsed,
        "BillMonth": billMonth,
        "BillItemList": List<dynamic>.from(historyBillDetails.map((x) => x.toJson())),
      };
}
