class FirebaseNotificationModel {
  String title;
  String body;
  String notiType;
  String notiTypeId;
  String payload;
  String chatFullname;
  String typeChat;
  String chatMasterId;
  String chatTypeAccount;
  bool isGroupChat;
  bool isNewMessageChat;

  FirebaseNotificationModel({
    this.title,
    this.body,
    this.notiType,
    this.notiTypeId,
    this.payload,
    this.chatFullname,
    this.typeChat,
    this.chatMasterId,
    this.chatTypeAccount,
    this.isGroupChat,
    this.isNewMessageChat,
  });

  factory FirebaseNotificationModel.fromJson(Map<dynamic, dynamic> json) => FirebaseNotificationModel(
        title: json["title"] ?? "",
        body: json["body"] ?? "",
        notiType: json["noti_type"] ?? "",
        notiTypeId: json["noti_type_id"] ?? "",
        chatFullname: json["chatFullname"] ?? "",
        typeChat: json["typeChat"] ?? "",
        chatMasterId: json["chatMasterId"] ?? "",
        chatTypeAccount: json["chatTypeAccount"] ?? "",
        isGroupChat: json["isGroupChat"].toString() == "true" ? true : false,
        isNewMessageChat: json["isNewMessageChat"].toString() == "true" ? true : false,
      );

  Map<String, dynamic> toJson() => {
        "title": title,
        "body": body,
        "noti_type": notiType,
        "noti_type_id": notiTypeId,
        "chatFullname": chatFullname,
        "typeChat": typeChat,
        "chatMasterId": chatMasterId,
        "chatTypeAccount": chatTypeAccount,
        "isGroupChat": isGroupChat,
        "isNewMessageChat": isNewMessageChat,
      };
}
