class FileModel {
  String extensionData;
  String fileContentBase64;
  String fileUrl;
  String fileName;
  String mimeType;
  String description;

  FileModel({
    this.extensionData,
    this.fileContentBase64,
    this.fileUrl,
    this.fileName,
    this.mimeType,
    this.description,
  });
  factory FileModel.fromJson(Map<String, dynamic> json) => FileModel(
        extensionData: json["ExtensionData"] ?? "",
        fileContentBase64: json["FileContent"] ?? "",
        fileUrl: json["FileUrl"] ?? "",
        fileName: json["FileName"] ?? "",
        mimeType: json["MimeType"] ?? "",
        description: json["Description"] ?? "",
      );

  Map<String, dynamic> toJson() => {
        "ExtensionData": extensionData,
        "FileContent": fileContentBase64,
        "FileName": fileName,
        "MimeType": mimeType,
        "Description": description,
      };
}
