class ElectricityLocationCustomerModel {
  String customerId;
  String customerName;
  String caNumber;
  String address;
  String tsit;
  String peaRegion;

  ElectricityLocationCustomerModel({
    this.customerId,
    this.customerName,
    this.caNumber,
    this.address,
    this.tsit,
    this.peaRegion,
  });

  factory ElectricityLocationCustomerModel.fromJson(Map<String, dynamic> json) => ElectricityLocationCustomerModel(
        customerId: json["CustomerId"],
        customerName: json["CustomerName"],
        caNumber: json["Ca"],
        address: json["Address"],
        tsit: json["tsit"],
        peaRegion: json["PeaRegionText"],
      );

  Map<String, dynamic> toJson() => {
        "CustomerId": customerId,
        "CustomerName": customerName,
        "Ca": caNumber,
        "Address": address,
        "tsit": tsit,
        "PeaRegionText": peaRegion,
      };
}
