class CustomerInfoModel {
  String customerId;
  String customerName;
  String caNumber;
  String address;
  String tsit;
  String tsitName;
  String peaRegionId;
  String peaRegion;

  CustomerInfoModel({
    this.customerId,
    this.customerName,
    this.caNumber,
    this.address,
    this.tsit,
    this.tsitName,
    this.peaRegionId,
    this.peaRegion,
  });

  factory CustomerInfoModel.fromJson(Map<String, dynamic> json) => CustomerInfoModel(
        customerId: json["customerId"] ?? "",
        customerName: json["customerName"] ?? "",
        caNumber: json["ca"] ?? "",
        address: json["customerAddress"] ?? "",
        tsit: json["TSICID"] ?? "",
        tsitName: json["TSICName"] ?? "",
        peaRegionId: json["BranchID"] ?? "",
        peaRegion: json["Branchname"] ?? "",
      );

  Map<String, dynamic> toJson() => {
        "CustomerId": customerId,
        "customerName": customerName,
        "Ca": caNumber,
        "Address": address,
        "tsit": tsit,
        "PeaRegionText": peaRegion,
      };
}
