class CustomerCAModel {
  String customerId;
  String caNumber;
  String customerName;
  String address;
  String peaRegion;

  CustomerCAModel({
    this.customerId,
    this.caNumber,
    this.customerName,
    this.address,
    this.peaRegion,
  });

  factory CustomerCAModel.fromJson(Map<String, dynamic> json) => CustomerCAModel(
        customerId: json["CustomerId"],
        caNumber: json["Ca"],
        customerName: json["CustomerName"],
        address: json["Address"],
        peaRegion: json["PeaRegionText"],
      );

  Map<String, dynamic> toJson() => {
        "CustomerId": customerId,
        "Ca": caNumber,
        "CustomerName": customerName,
        "Address": address,
        "PeaRegionText": peaRegion,
      };
}
