class ChatReaderModel {
  String id;
  String userId;
  String username;
  String status;
  String companyName;
  String createDate;

  ChatReaderModel({
    this.id,
    this.userId,
    this.username,
    this.status,
    this.companyName,
    this.createDate,
  });

  factory ChatReaderModel.fromJson(Map<String, dynamic> json) => ChatReaderModel(
        id: json["Id"],
        userId: json["UserId"] ?? "",
        username: json["UserName"] ?? "",
        status: json["Status"] ?? "",
        companyName: json["CustomerName"] ?? "",
        createDate: json["CreateDate"] ?? "",
      );

  Map<String, dynamic> toJson() => {
        "Id": id,
        "UserId": userId,
        "UserName": username,
        "Status": status,
        "CustomerName": companyName,
        "CreateDate": createDate,
      };
}
