import 'package:meta/meta.dart';

class ChatNotificationModel {
  ChatNotificationModel({
    this.title,
    this.body,
    this.topic,
    this.sound,
    this.priority,
    this.androidNotificationChannel,
    this.dataParams,
    this.registrationIds,
    this.authenKey,
  });

  String title;
  String body;
  String topic;
  String sound;
  String priority;
  @required
  String authenKey;
  String androidNotificationChannel;
  List<ChatNotificationDataParamModel> dataParams;
  List<String> registrationIds;

  factory ChatNotificationModel.fromJson(Map<String, dynamic> json) => ChatNotificationModel(
        title: json["title"],
        body: json["body"],
        topic: json["topic"],
        sound: json["sound"],
        priority: json["priority"],
        androidNotificationChannel: json["androidNotificationChannel"],
        dataParams: List<ChatNotificationDataParamModel>.from(json["dataParams"].map((x) => ChatNotificationDataParamModel.fromJson(x))),
        registrationIds: List<String>.from(json["registrationIds"].map((x) => x)),
      );

  Map<String, dynamic> toJson() => {
        "title": title,
        "body": body,
        "topic": topic,
        "sound": sound,
        "priority": priority,
        "androidNotificationChannel": androidNotificationChannel,
        "AuthenKey": authenKey,
        "dataParams": List<dynamic>.from(dataParams.map((x) => x.toJson())),
        "registrationIds": List<dynamic>.from(registrationIds.map((x) => x)),
      };
}

class ChatNotificationDataParamModel {
  ChatNotificationDataParamModel({
    this.key,
    this.value,
  });

  String key;
  dynamic value;

  factory ChatNotificationDataParamModel.fromJson(Map<String, dynamic> json) => ChatNotificationDataParamModel(
        key: json["key"],
        value: json["value"],
      );

  Map<String, dynamic> toJson() => {
        "key": key,
        "value": value,
      };
}
