import 'package:peasmartcare/models/chat_user_model.dart';

class ChatMessageModel {
  String id;
  String content;
  String fileUrl;
  String fileName;
  String createdAt;
  String createdTime;
  int type;
  String chatMasterId;
  String chatMaster;
  String accountId;
  String typeChat;
  bool isReaded;
  bool isTempData;
  int totalPage;
  String currentDate;
  ChatUserModel user;

  ChatMessageModel({
    this.id,
    this.content,
    this.fileUrl,
    this.fileName,
    this.type,
    this.createdAt,
    this.createdTime,
    this.chatMasterId,
    this.chatMaster,
    this.accountId,
    this.typeChat,
    this.isReaded,
    this.isTempData,
    this.totalPage,
    this.currentDate,
    this.user,
  });

  factory ChatMessageModel.fromJson(Map<String, dynamic> json) => ChatMessageModel(
        id: json["Id"],
        content: json["content"] ?? "",
        fileUrl: json["fileUrl"] ?? "",
        fileName: json["FileName"] ?? "",
        type: json["Type"] ?? "",
        createdAt: json["createAt"] ?? "",
        chatMasterId: json["ChatMasterId"] ?? "",
        chatMaster: json["ChatMaster"] ?? "",
        accountId: json["AccountId"] ?? "",
        typeChat: json["TypeChat"] ?? "",
        isReaded: json["ReadsCnt"] > 0, //int.parse(json["Status"]) ?? 0,
        totalPage: json["TotalPage"] ?? "",
        user: ChatUserModel.fromJson(json["user"]),
      );

  Map<String, dynamic> toJson() => {
        "Id": id,
        "content": content,
        "fileUrl": fileUrl,
        "Type": type,
        "createdAt": createdAt,
        "ChatMasterId": chatMasterId,
        "ChatMaster": chatMaster,
        "AccountId": accountId,
        "TypeChat": typeChat,
        "ReadsCnt": isReaded,
        "user": user.toJson(),
      };
}
