class ActivityModel {
  String subject;
  String startDate;
  String endDate;
  String location;
  String activityType;

  ActivityModel({
    this.subject,
    this.startDate,
    this.endDate,
    this.location,
    this.activityType,
  });

  factory ActivityModel.fromJson(Map<String, dynamic> json) => ActivityModel(
        subject: json["RelationshipActivityName"]??"",
        startDate: json["RelationshipActivityStartDate"]??"",
        endDate: json["RelationshipActivityEndDate"]??"",
        location: json["RelationshipActivityPlace"]??"",
        activityType: json["CategoryRelationshipActivityName"]??"",
      );

  Map<String, dynamic> toJson() => {
        "RelationshipActivityName": subject,
        "RelationshipActivityStartDate": startDate,
        "RelationshipActivityEndDate": endDate,
        "RelationshipActivityPlace": location,
        "CategoryRelationshipActivityName": activityType,
      };
}
