import 'package:flutter/material.dart';
import 'package:peasmartcare/constraints/app_data.dart';
import 'package:peasmartcare/constraints/image_asset.dart';
import 'package:peasmartcare/pages/profile/profile.dart';

class ProfileAvatar extends StatefulWidget {
  final double width;
  final bool isLeft;
  final bool disableEditProfile;
  // final VoidCallback onTap;

  const ProfileAvatar({
    Key key,
    this.width = 55,
    this.isLeft = false,
    this.disableEditProfile = false,
    // this.onTap,
  }) : super(key: key);

  @override
  _ProfileAvatarState createState() => _ProfileAvatarState();
}

class _ProfileAvatarState extends State<ProfileAvatar> {
  @override
  Widget build(BuildContext context) {
    // return widget.isLeft ? _leftAvatar() : _rightAvatar();
    return _rightAvatar();
  }

  // Widget _leftAvatar() {
  //   return Positioned(
  //     top: 1,
  //     left: 1,
  //     right: 0,
  //     child: Container(
  //       padding: EdgeInsets.all(5),
  //       height: 55,
  //       width: widget.width,
  //       child: const DecoratedBox(
  //         decoration: const BoxDecoration(
  //           shape: BoxShape.circle,
  //           image: DecorationImage(
  //             fit: BoxFit.fill,
  //             image: AssetImage(ImageAsset.kunlavutImg),
  //           ),
  //         ),
  //       ),
  //     ),
  //   );
  // }

  Widget _rightAvatar() {
    return GestureDetector(
      child: Stack(
        children: [
          Container(
            padding: EdgeInsets.all(5),
            height: 55,
            width: widget.width,
            child: const DecoratedBox(
              decoration: const BoxDecoration(
                shape: BoxShape.circle,
                image: DecorationImage(
                  fit: BoxFit.fill,
                  image: AssetImage(ImageAsset.imageDefaultAvartar),
                ),
              ),
            ),
          ),
          Positioned(
            bottom: 5,
            right: 5,
            child: Container(
              child: Stack(
                children: <Widget>[
                  Icon(
                    Icons.edit,
                    color: Colors.white70,
                    size: 30,
                  ),
                  Positioned(
                    right: 5,
                    bottom: 2,
                    child: Icon(
                      Icons.edit,
                      color: Colors.yellow[800],
                      size: 23,
                    ),
                  ),
                ],
              ),
            ),
          )
        ],
      ),
      onTap: () {
        if (!widget.disableEditProfile) {
          Navigator.of(context).popUntil((route) => route.isFirst);
          Navigator.push(
            context,
            MaterialPageRoute(builder: (context) => ProfilePage()),
          );
        }
      },
      // onTap: widget.onTap == null
      //     ? () {}
      //     : () {
      //         widget.onTap();
      //       },
    );
  }
}
