import 'package:flutter/material.dart';

class PEAAppBar extends StatelessWidget with PreferredSizeWidget {
  final leading;
  final dynamic title;
  final List<Widget> actions;

  PEAAppBar({
    Key key,
    this.leading,
    this.title,
    this.actions,
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return AppBar(
      elevation: 0.0,
      leading: leading ??
          Builder(
            builder: (BuildContext context) {
              return IconButton(
                icon: Icon(Icons.arrow_back_ios),
                onPressed: () {
                  Navigator.pop(context);
                },
                tooltip: MaterialLocalizations.of(context).openAppDrawerTooltip,
              );
            },
          ),
      title: title == null ? Text("") : (!(title is Widget) ? Text(title) : title),
      //
      // title: title == ""
      //     ? Container(
      //         child: Row(
      //           mainAxisAlignment: MainAxisAlignment.center,
      //           children: <Widget>[
      //             SizedBox(
      //               height: 35,
      //               child: Image.asset(ImageAsset.logo),
      //             ),
      //           ],
      //         ),
      //       )
      //     : Text(title),
      actions: actions,
    );
  }

  @override
  Size get preferredSize => Size.fromHeight(kToolbarHeight);
}
