import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:fluttericon/web_symbols_icons.dart';
import 'package:peasmartcare/blocs/logout/logout_bloc.dart';
import 'package:peasmartcare/constraints/app_data.dart';
import 'package:peasmartcare/pages/auth/login.dart';
import 'package:peasmartcare/pages/auth/logout.dart';

class Logout extends StatefulWidget {
  @override
  _LogoutState createState() => _LogoutState();
}

class _LogoutState extends State<Logout> {
  @override
  Widget build(BuildContext context) {
    return InkWell(
      child: BlocListener<LogoutBloc, LogoutState>(
        listener: (context, state) {
          if (state is LogoutLoaded) {
            Navigator.of(context).popUntil((route) => route.isFirst);
            Navigator.pushReplacement(
              context,
              MaterialPageRoute(builder: (context) => LogoutPage()),
            );
          } else if (state is LogoutErrorUnauthorized) {
            Navigator.of(context).popUntil((route) => route.isFirst);
            Navigator.pushReplacement(
              context,
              MaterialPageRoute(builder: (context) => LogoutPage()),
            );
          }
        },
        child: BlocBuilder<LogoutBloc, LogoutState>(
          builder: (context, state) {
            return Container(
              // constraints: BoxConstraints(minWidth: 350, maxWidth: 350),
              // height: 80,
              // margin: EdgeInsets.only(top: 20),
              child: Card(
                color: Color(AppData.yellowColor),
                child: Padding(
                  padding: const EdgeInsets.all(10),
                  child: Text(
                    "ออกจากระบบ",
                    style: TextStyle(
                      color: Color(AppData.purpleColor),
                      fontWeight: FontWeight.bold,
                      fontSize: 20,
                    ),
                  ),
                ),
              ),
            );
            // return Container(
            //   width: 55,
            //   padding: EdgeInsets.fromLTRB(15, 5, 15, 5),
            //   child: Icon(WebSymbols.logout),
            // );
          },
        ),
      ),
      onTap: () {
        context.read<LogoutBloc>().add(LogoutOnPressed());
      },
    );
  }
}
