import 'package:flutter/material.dart';
import 'package:fluttericon/elusive_icons.dart';
import 'package:peasmartcare/components/body_layout.dart';
import 'package:peasmartcare/constraints/app_data.dart';
import 'package:peasmartcare/pages/auth/authen.dart';

class ConnectionFailPage extends StatefulWidget {
  @override
  _ConnectionFailPageState createState() => _ConnectionFailPageState();
}

class _ConnectionFailPageState extends State<ConnectionFailPage> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      body: BodyLayout(
        layoutType: LayoutType.ONLY_CHILD,
        color: Colors.purple[100],
        top: 0,
        child: _body(),
      ),
    );
  }

  Widget _body() {
    Size deviceSize = MediaQuery.of(context).size;
    return Container(
      width: double.infinity,
      height: deviceSize.height,
      child: Column(
        mainAxisAlignment: MainAxisAlignment.center,
        crossAxisAlignment: CrossAxisAlignment.center,
        children: [
          Text(
            "การเชื่อมต่อขัดข้อง",
            style: TextStyle(
              fontSize: 30,
              color: Color(AppData.purpleColor),
            ),
          ),
          SizedBox(height: 15),
          RaisedButton.icon(
            color: Color(AppData.yellowColor),
            icon: Icon(
              Elusive.arrows_cw,
              size: 15,
              color: Color(AppData.purpleColor),
            ),
            label: const Text(
              'ลองอีกครั้ง',
              style: TextStyle(
                fontSize: 20,
                color: Color(AppData.purpleColor),
              ),
            ),
            onPressed: () {
              Navigator.pushReplacement(
                context,
                MaterialPageRoute(builder: (context) => AuthenPage()),
              );
            },
          ),
        ],
      ),
    );
  }
}
