import 'dart:convert';
import 'dart:io';
import 'dart:typed_data';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:peasmartcare/blocs/chat_list/chat_list_bloc.dart';

class CameraPreviewScreen extends StatefulWidget {
  final String imgPath;
  final String fileName;
  final String typeChat;
  final String chatMasterId;
  final String typeAccount;
  final bool isGroupChat;

  CameraPreviewScreen({
    this.imgPath,
    this.fileName,
    this.typeChat,
    this.chatMasterId,
    this.typeAccount,
    this.isGroupChat,
  });

  @override
  _CameraPreviewScreenState createState() => _CameraPreviewScreenState();
}

class _CameraPreviewScreenState extends State<CameraPreviewScreen> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        automaticallyImplyLeading: true,
      ),
      body: Container(
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.stretch,
          children: <Widget>[
            Expanded(
              flex: 2,
              child: Image.file(
                File(widget.imgPath),
                fit: BoxFit.cover,
              ),
            ),
            Align(
              alignment: Alignment.bottomCenter,
              child: Container(
                width: double.infinity,
                height: 60,
                color: Colors.black,
                child: Center(
                  child: IconButton(
                    icon: Icon(
                      Icons.send,
                      color: Colors.white,
                    ),
                    onPressed: () {
                      getImageBase64().then((base64Image) {
                        print('here now');
                        onSendMessage(
                          content: base64Image,
                          type: 2,
                          chatMasterId: widget.chatMasterId,
                          typeAccount: widget.typeAccount,
                          typeChat: widget.typeChat,
                          isGroupChat: widget.isGroupChat,
                        );
                        Navigator.pop(context);
                        Navigator.pop(context);
                      });
                    },
                  ),
                ),
              ),
            )
          ],
        ),
      ),
    );
  }

  Future getImageBase64() async {
    List<int> fileBytes = File(widget.imgPath).readAsBytesSync();

    return base64Encode(fileBytes);
  }

  void onSendMessage({String content, int type, String chatMasterId, String typeAccount, String typeChat, bool isGroupChat}) {
    context.read<ChatListBloc>().add(
          ChatListOnSendMessage(
            chatMasterId: chatMasterId,
            typeAccount: typeAccount,
            content: content,
            type: type,
            typeChat: typeChat,
            isGroupChat: isGroupChat,
          ),
        );
  }
}
