part of 'verify_otp_bloc.dart';

abstract class VerifyOtpState extends Equatable {
  const VerifyOtpState();

  @override
  List<Object> get props => [];
}

class VerifyOtpInitial extends VerifyOtpState {
  @override
  List<Object> get props => [];
}

class VerifyOtpLoading extends VerifyOtpState {}

class VerifyOtpLoaded extends VerifyOtpState {
  final bool result;

  VerifyOtpLoaded({
    this.result,
  });
  @override
  List<Object> get props => [result];
}

class VerifyOtpNotFound extends VerifyOtpState {}

class VerifyOtpError extends VerifyOtpState {
  final String message;
  const VerifyOtpError({this.message});
  @override
  List<Object> get props => [message];
}

class VerifyOtpErrorUnauthorized extends VerifyOtpState {}
