part of 'timeline_list_bloc.dart';

abstract class TimelineListState extends Equatable {
  const TimelineListState();

  @override
  List<Object> get props => [];
}

class TimelineListInitial extends TimelineListState {
  @override
  List<Object> get props => [];
}

class TimelineListLoading extends TimelineListState {}

class TimelineListLoaded extends TimelineListState {
  final List<TimelineModel> result;

  TimelineListLoaded({
    this.result,
  });
  @override
  List<Object> get props => [result];
}

class TimelineListNotFound extends TimelineListState {}

class TimelineListError extends TimelineListState {
  final String message;
  const TimelineListError({this.message});
  @override
  List<Object> get props => [message];
}

class TimelineListErrorUnauthorized extends TimelineListState {}
