import 'dart:async';

import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:equatable/equatable.dart';
import 'package:peasmartcare/models/result_data_model.dart';
import 'package:peasmartcare/models/timeline_model.dart';
import 'package:peasmartcare/services/timeline_service.dart';
import 'package:peasmartcare/utils/share_data_util.dart';
import 'package:peasmartcare/utils/clear_count_notification_util.dart';

part 'timeline_list_event.dart';
part 'timeline_list_state.dart';

class TimelineListBloc extends Bloc<TimelineListEvent, TimelineListState> {
  TimelineImpService service = TimelineImpService();

  ResultData resultData;

  TimelineListBloc() : super(TimelineListInitial());

  @override
  Stream<TimelineListState> mapEventToState(TimelineListEvent event) async* {
    try {
      if (event is TimelineListGetList) {
        yield TimelineListLoading();

        await ClearCountNotificationUtil.timeline();

        resultData = await service.getList(
          customerId: ShareDataUtil.getCustomerId(),
          authenKey: ShareDataUtil.getAuthenKey(),
        );

        if (resultData.statusCode == 401) {
          yield TimelineListErrorUnauthorized();
        } else {
          yield TimelineListLoaded(result: resultData.result);
        }
      }
    } catch (e) {
      yield TimelineListError(message: "Error");
    }
  }
}
