part of 'survey_question_edit_bloc.dart';

abstract class SurveyQuestionEditState extends Equatable {
  const SurveyQuestionEditState();
  @override
  List<Object> get props => [];
}

class SurveyQuestionEditInitial extends SurveyQuestionEditState {
  @override
  List<Object> get props => [];
}

class SurveyQuestionEditLoading extends SurveyQuestionEditState {}

class SurveyQuestionEditLoaded extends SurveyQuestionEditState {
  final SurveyQuestionModel result;
  final int currentIndex;
  final bool isNext;
  final String customerId;
  final bool saveSuccess;

  SurveyQuestionEditLoaded({
    this.result,
    this.currentIndex,
    this.isNext,
    this.customerId,
    this.saveSuccess,
  });
  @override
  List<Object> get props => [result, currentIndex, isNext, customerId, saveSuccess];
}

class SurveyQuestionEditNotFound extends SurveyQuestionEditState {}

class SurveyQuestionEditError extends SurveyQuestionEditState {
  final String message;
  const SurveyQuestionEditError({this.message});
  @override
  List<Object> get props => [message];
}

class SurveyQuestionEditErrorUnauthorized extends SurveyQuestionEditState {}
