import 'dart:async';

import 'package:bloc/bloc.dart';
import 'package:equatable/equatable.dart';
import 'package:peasmartcare/models/result_data_model.dart';
import 'package:peasmartcare/models/survey_answer_model.dart';
import 'package:peasmartcare/models/survey_question_model.dart';
import 'package:peasmartcare/services/survey_service.dart';
import 'package:peasmartcare/utils/share_data_util.dart';

part 'survey_question_edit_event.dart';
part 'survey_question_edit_state.dart';

class SurveyQuestionEditBloc extends Bloc<SurveyQuestionEditEvent, SurveyQuestionEditState> {
  SurveyImpService service = SurveyImpService();

  ResultData resultData;
  ResultData saveResultData;
  List<SurveyAnswerModel> answerList = List<SurveyAnswerModel>();
  String surveyId;
  int currentIndex = 0;
  int total = 0;

  SurveyQuestionEditBloc() : super(SurveyQuestionEditInitial());

  @override
  Stream<SurveyQuestionEditState> mapEventToState(SurveyQuestionEditEvent event) async* {
    try {
      if (event is SurveyQuestionEditAddSurveyId) {
        surveyId = event.surveyId;
      } else if (event is SurveyQuestionEditGetCurrentQuestion) {
        yield SurveyQuestionEditLoading();
        currentIndex = event.currentIndex;
        bool isNext = (currentIndex < (total - 1));

        if (currentIndex < 0)
          currentIndex = 0;
        else if (currentIndex > (total - 1)) currentIndex = (total - 1);

        await Future.delayed(Duration(milliseconds: 100));

        if (resultData.statusCode == 401) {
          yield SurveyQuestionEditErrorUnauthorized();
        } else {
          yield SurveyQuestionEditLoaded(
            result: resultData.result[currentIndex],
            currentIndex: currentIndex,
            isNext: isNext,
            customerId: ShareDataUtil.getCustomerId(),
            saveSuccess: null,
          );
        }
      } else if (event is SurveyQuestionEditAddAnswer) {
        SurveyAnswerModel answer = event.answer;
        // print(answer.questionId);
        // print(answer.choiceId);
        // print(answer.value);
        answerList.add(answer);
      } else if (event is SurveyQuestionEditSendAnswer) {
        yield SurveyQuestionEditLoading();

        saveResultData = await service.sendAnswer(answerList: answerList);

        if (saveResultData.statusCode == 401) {
          yield SurveyQuestionEditErrorUnauthorized();
        } else {
          yield SurveyQuestionEditLoaded(
            result: resultData.result[currentIndex],
            currentIndex: currentIndex,
            isNext: (currentIndex < (total - 1)),
            customerId: ShareDataUtil.getCustomerId(),
            saveSuccess: saveResultData.result,
          );
        }
      } else if (event is SurveyQuestionEditGetList) {
        yield SurveyQuestionEditLoading();

        answerList = List<SurveyAnswerModel>();

        resultData = await service.getQuestion(
          surveyId: surveyId,
          authenKey: ShareDataUtil.getAuthenKey(),
        );

        currentIndex = 0;
        total = resultData.result.length;

        if (resultData.statusCode == 401) {
          yield SurveyQuestionEditErrorUnauthorized();
        } else {
          if (total != 0) {
            yield SurveyQuestionEditLoaded(
              result: resultData.result[currentIndex],
              currentIndex: currentIndex,
              isNext: (currentIndex < (total - 1)),
              customerId: ShareDataUtil.getCustomerId(),
              saveSuccess: null,
            );
          } else {
            yield SurveyQuestionEditNotFound();
          }
        }
      }
    } catch (e) {
      yield SurveyQuestionEditError(message: "Error");
    }
  }
}
