part of 'survey_group_list_bloc.dart';

abstract class SurveyGroupListState extends Equatable {
  const SurveyGroupListState();
  @override
  List<Object> get props => [];
}

class SurveyGroupListInitial extends SurveyGroupListState {
  @override
  List<Object> get props => [];
}

class SurveyGroupListLoading extends SurveyGroupListState {}

class SurveyGroupListLoaded extends SurveyGroupListState {
  final List<SurveyGroupModel> result;

  SurveyGroupListLoaded({
    this.result,
  });
  @override
  List<Object> get props => [result];
}

class SurveyGroupListNotFound extends SurveyGroupListState {}

class SurveyGroupListError extends SurveyGroupListState {
  final String message;
  const SurveyGroupListError({this.message});
  @override
  List<Object> get props => [message];
}

class SurveyGroupListErrorUnauthorized extends SurveyGroupListState {}
