import 'dart:async';

import 'package:bloc/bloc.dart';
import 'package:equatable/equatable.dart';
import 'package:peasmartcare/models/result_data_model.dart';
import 'package:peasmartcare/models/survey_group_model.dart';
import 'package:peasmartcare/services/survey_service.dart';
import 'package:peasmartcare/utils/share_data_util.dart';

part 'survey_group_list_event.dart';
part 'survey_group_list_state.dart';

class SurveyGroupListBloc extends Bloc<SurveyGroupListEvent, SurveyGroupListState> {
  SurveyImpService service = SurveyImpService();

  ResultData resultData;

  SurveyGroupListBloc() : super(SurveyGroupListInitial());

  @override
  Stream<SurveyGroupListState> mapEventToState(SurveyGroupListEvent event) async* {
    try {
      if (event is SurveyGroupListGetList) {
        yield SurveyGroupListLoading();

        resultData = await service.getGroupList(
          authenKey: ShareDataUtil.getAuthenKey(),
        );

        if (resultData.statusCode == 401) {
          yield SurveyGroupListErrorUnauthorized();
        } else {
          yield SurveyGroupListLoaded(result: resultData.result);
        }
      }
    } catch (e) {
      yield SurveyGroupListError(message: "Error");
    }
  }
}
