part of 'select_electricity_location_list_bloc.dart';

abstract class SelectElectricityLocationListState extends Equatable {
  const SelectElectricityLocationListState();

  @override
  List<Object> get props => [];
}

class SelectElectricityLocationListInitial extends SelectElectricityLocationListState {
  @override
  List<Object> get props => [];
}

class SelectElectricityLocationListLoading extends SelectElectricityLocationListState {}

class SelectElectricityLocationListLoaded extends SelectElectricityLocationListState {
  final List<ElectricityLocationCustomerModel> result;
  final ElectricityLocationCustomerModel electricityLocationCustomer;
  final bool deleteSuccess;

  SelectElectricityLocationListLoaded({
    this.result,
    this.electricityLocationCustomer,
    this.deleteSuccess,
  });
  @override
  List<Object> get props => [result, electricityLocationCustomer, deleteSuccess];
}

class SelectElectricityLocationListNotFound extends SelectElectricityLocationListState {}

class SelectElectricityLocationListError extends SelectElectricityLocationListState {
  final String message;
  const SelectElectricityLocationListError({this.message});
  @override
  List<Object> get props => [message];
}

class SelectElectricityLocationListErrorUnauthorized extends SelectElectricityLocationListState {}
