part of 'resend_otp_bloc.dart';

abstract class ResendOtpState extends Equatable {
  const ResendOtpState();

  @override
  List<Object> get props => [];
}

class ResendOtpInitial extends ResendOtpState {
  @override
  List<Object> get props => [];
}

class ResendOtpLoading extends ResendOtpState {}

class ResendOtpLoaded extends ResendOtpState {
  final bool result;
  final OtpModel otpResult;

  ResendOtpLoaded({
    this.result,
    this.otpResult,
  });
  @override
  List<Object> get props => [result, otpResult];
}

class ResendOtpNotFound extends ResendOtpState {}

class ResendOtpError extends ResendOtpState {
  final String message;
  const ResendOtpError({this.message});
  @override
  List<Object> get props => [message];
}

class ResendOtpErrorUnauthorized extends ResendOtpState {}
