part of 'report_incident_history_list_bloc.dart';

abstract class ReportIncidentHistoryListState extends Equatable {
  const ReportIncidentHistoryListState();
  @override
  List<Object> get props => [];
}

class ReportIncidentHistoryListInitial extends ReportIncidentHistoryListState {
  @override
  List<Object> get props => [];
}

class ReportIncidentHistoryListLoading extends ReportIncidentHistoryListState {}

class ReportIncidentHistoryListLoaded extends ReportIncidentHistoryListState {
  final List<ReportIncidentHistoryModel> result;

  ReportIncidentHistoryListLoaded({
    this.result,
  });
  @override
  List<Object> get props => [result];
}

class ReportIncidentHistoryListNotFound extends ReportIncidentHistoryListState {}

class ReportIncidentHistoryListError extends ReportIncidentHistoryListState {
  final String message;
  const ReportIncidentHistoryListError({this.message});
  @override
  List<Object> get props => [message];
}

class ReportIncidentHistoryListErrorUnauthorized extends ReportIncidentHistoryListState {}
