import 'dart:async';

import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:equatable/equatable.dart';
import 'package:peasmartcare/models/report_incident_history_model.dart';
import 'package:peasmartcare/models/result_data_model.dart';
import 'package:peasmartcare/services/report_incident_service.dart';
import 'package:peasmartcare/utils/share_data_util.dart';
import 'package:peasmartcare/utils/clear_count_notification_util.dart';

part 'report_incident_history_list_event.dart';
part 'report_incident_history_list_state.dart';

class ReportIncidentHistoryListBloc extends Bloc<ReportIncidentHistoryListEvent, ReportIncidentHistoryListState> {
  ReportIncidentImpService service = ReportIncidentImpService();

  ResultData resultData;

  ReportIncidentHistoryListBloc() : super(ReportIncidentHistoryListInitial());

  @override
  Stream<ReportIncidentHistoryListState> mapEventToState(ReportIncidentHistoryListEvent event) async* {
    try {
      if (event is ReportIncidentHistoryListGetList) {
        yield ReportIncidentHistoryListLoading();

        await ClearCountNotificationUtil.reportIncident();

        resultData = await service.getHistoryList(
          customerId: ShareDataUtil.getCustomerId(),
          authenKey: ShareDataUtil.getAuthenKey(),
        );
        if (resultData.statusCode == 401) {
          yield ReportIncidentHistoryListErrorUnauthorized();
        } else {
          yield ReportIncidentHistoryListLoaded(result: resultData.result);
        }
      }
    } catch (e) {
      yield ReportIncidentHistoryListError(message: "Error");
    }
  }
}
