part of 'register_bloc.dart';

abstract class RegisterState extends Equatable {
  const RegisterState();

  @override
  List<Object> get props => [];
}

class RegisterInitial extends RegisterState {
  @override
  List<Object> get props => [];
}

class RegisterLoading extends RegisterState {}

class RegisterLoaded extends RegisterState {
  final bool result;
  final OtpModel otpResult;

  RegisterLoaded({
    this.result,
    this.otpResult,
  });
  @override
  List<Object> get props => [result, otpResult];
}

class RegisterNotFound extends RegisterState {}

class RegisterError extends RegisterState {
  final String message;
  const RegisterError({this.message});
  @override
  List<Object> get props => [message];
}
