import 'dart:async';

import 'package:bloc/bloc.dart';
import 'package:equatable/equatable.dart';
import 'package:peasmartcare/models/questionnaire_answer_model.dart';
import 'package:peasmartcare/models/questionnaire_question_model.dart';
import 'package:peasmartcare/models/result_data_model.dart';
import 'package:peasmartcare/services/questionnaire_service.dart';
import 'package:peasmartcare/utils/share_data_util.dart';

part 'questionnaire_question_event.dart';
part 'questionnaire_question_state.dart';

class QuestionnaireQuestionBloc extends Bloc<QuestionnaireQuestionEvent, QuestionnaireQuestionState> {
  QuestionnaireImpService service = QuestionnaireImpService();

  ResultData resultData;
  ResultData saveResultData;
  List<QuestionnaireAnswerModel> answerList = List<QuestionnaireAnswerModel>();
  String questionnaireId;
  int currentIndex = 0;
  int total = 0;

  QuestionnaireQuestionBloc() : super(QuestionnaireQuestionInitial());

  @override
  Stream<QuestionnaireQuestionState> mapEventToState(QuestionnaireQuestionEvent event) async* {
    try {
      if (event is QuestionnaireQuestionAddQuestionnaireId) {
        questionnaireId = event.questionnaireId;
      } else if (event is QuestionnaireQuestionGetCurrentQuestion) {
        yield QuestionnaireQuestionLoading();
        currentIndex = event.currentIndex;
        bool isNext = (currentIndex < (total - 1));

        if (currentIndex < 0)
          currentIndex = 0;
        else if (currentIndex > (total - 1)) currentIndex = (total - 1);

        await Future.delayed(Duration(milliseconds: 100));

        if (resultData.statusCode == 401) {
          yield QuestionnaireQuestionErrorUnauthorized();
        } else {
          yield QuestionnaireQuestionLoaded(
            result: resultData.result[currentIndex],
            currentIndex: currentIndex,
            isNext: isNext,
            customerId: ShareDataUtil.getCustomerId(),
            saveSuccess: null,
          );
        }
      } else if (event is QuestionnaireQuestionAddAnswer) {
        QuestionnaireAnswerModel answer = event.answer;

        answerList.add(answer);
      } else if (event is QuestionnaireQuestionSendAnswer) {
        yield QuestionnaireQuestionLoading();

        saveResultData = await service.sendAnswer(answerList: answerList);
        if (resultData.statusCode == 401) {
          yield QuestionnaireQuestionErrorUnauthorized();
        } else {
          yield QuestionnaireQuestionLoaded(
            result: resultData.result[currentIndex],
            currentIndex: currentIndex,
            isNext: (currentIndex < (total - 1)),
            customerId: ShareDataUtil.getCustomerId(),
            saveSuccess: saveResultData.result,
          );
        }
      } else if (event is QuestionnaireQuestionGetList) {
        yield QuestionnaireQuestionLoading();

        answerList = List<QuestionnaireAnswerModel>();

        resultData = await service.getQuestion(
          questionnaireId: questionnaireId,
          authenKey: ShareDataUtil.getAuthenKey(),
        );

        currentIndex = 0;
        total = resultData.result.length;

        if (total != 0) {
          yield QuestionnaireQuestionLoaded(
            result: resultData.result[currentIndex],
            currentIndex: currentIndex,
            isNext: (currentIndex < (total - 1)),
            customerId: ShareDataUtil.getCustomerId(),
            saveSuccess: null,
          );
        } else {
          yield QuestionnaireQuestionNotFound();
        }
      }
    } catch (e) {
      yield QuestionnaireQuestionError(message: "Error");
    }
  }
}
