part of 'questionnaire_list_bloc.dart';

abstract class QuestionnaireListState extends Equatable {
  const QuestionnaireListState();

  @override
  List<Object> get props => [];
}

class QuestionnaireListInitial extends QuestionnaireListState {
  @override
  List<Object> get props => [];
}

class QuestionnaireListLoading extends QuestionnaireListState {}

class QuestionnaireListLoaded extends QuestionnaireListState {
  final List<QuestionnaireModel> result;

  QuestionnaireListLoaded({
    this.result,
  });
  @override
  List<Object> get props => [result];
}

class QuestionnaireListNotFound extends QuestionnaireListState {}

class QuestionnaireListError extends QuestionnaireListState {
  final String message;
  const QuestionnaireListError({this.message});
  @override
  List<Object> get props => [message];
}

class QuestionnaireListErrorUnauthorized extends QuestionnaireListState {}
