import 'dart:async';

import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:equatable/equatable.dart';
import 'package:peasmartcare/models/notification_model.dart';
import 'package:peasmartcare/models/result_data_model.dart';
import 'package:peasmartcare/services/notification_service.dart';
import 'package:peasmartcare/utils/share_data_util.dart';

part 'notification_list_event.dart';
part 'notification_list_state.dart';

class NotificationListBloc extends Bloc<NotificationListEvent, NotificationListState> {
  NotificationImpService service = NotificationImpService();

  ResultData resultData;

  NotificationListBloc() : super(NotificationListInitial());

  @override
  Stream<NotificationListState> mapEventToState(NotificationListEvent event) async* {
    try {
      if (event is NotificationListGetList) {
        yield NotificationListLoading();

        resultData = await service.getList(
          customerId: ShareDataUtil.getCustomerId(),
          authenKey: ShareDataUtil.getAuthenKey(),
        );

        if (resultData.statusCode == 401) {
          yield NotificationListErrorUnauthorized();
        } else {
          yield NotificationListLoaded(result: resultData.result);
        }
      }
    } catch (e) {
      yield NotificationListNotFound();
      // yield NotificationListError(message: "เกิดปัญหาขัดข้อง");
    }
  }
}
