part of 'news_detail_bloc.dart';

abstract class NewsDetailState extends Equatable {
  const NewsDetailState();

  @override
  List<Object> get props => [];
}

class NewsDetailInitial extends NewsDetailState {
  @override
  List<Object> get props => [];
}

class NewsDetailLoading extends NewsDetailState {}

class NewsDetailLoaded extends NewsDetailState {
  final NewsModel result;

  NewsDetailLoaded({
    this.result,
  });
  // @override
  // List<Object> get props => [result.detailBase64];
}

class NewsDetailNotFound extends NewsDetailState {}

class NewsDetailError extends NewsDetailState {
  final String message;
  const NewsDetailError({this.message});
  @override
  List<Object> get props => [message];
}

class NewsDetailErrorUnauthorized extends NewsDetailState {}
