part of 'home_app_bar_bloc.dart';

abstract class HomeAppBarState extends Equatable {
  const HomeAppBarState();
  @override
  List<Object> get props => [];
}

class HomeAppBarInitial extends HomeAppBarState {
  @override
  List<Object> get props => [];
}
class HomeAppBarLoading extends HomeAppBarState {}

class HomeAppBarLoaded extends HomeAppBarState {
  final String result;

  HomeAppBarLoaded({
    this.result,
  });
  @override
  List<Object> get props => [result];
}

class HomeAppBarNotFound extends HomeAppBarState {}

class HomeAppBarError extends HomeAppBarState {
  final String message;
  const HomeAppBarError({this.message});
  @override
  List<Object> get props => [message];
}