import 'dart:async';

import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:equatable/equatable.dart';
import 'package:peasmartcare/constraints/app_data.dart';
import 'package:peasmartcare/models/chat_room_model.dart';
import 'package:peasmartcare/models/customer_info_model.dart';
import 'package:peasmartcare/models/result_data_model.dart';
import 'package:peasmartcare/models/user_model.dart';
import 'package:peasmartcare/services/chat_service.dart';
import 'package:peasmartcare/utils/app_util.dart';
import 'package:peasmartcare/utils/clear_count_notification_util.dart';
import 'package:peasmartcare/utils/share_data_util.dart';

part 'home_app_bar_event.dart';
part 'home_app_bar_state.dart';

class HomeAppBarBloc extends Bloc<HomeAppBarEvent, HomeAppBarState> {
  ResultData resultData;

  HomeAppBarBloc() : super(HomeAppBarInitial());

  @override
  Stream<HomeAppBarState> mapEventToState(HomeAppBarEvent event) async* {
    try {
      if (event is HomeAppBarGetData) {
        yield HomeAppBarLoading();
        UserModel user = ShareDataUtil.getUserInfo();
        CustomerInfoModel customerInfo = await ShareDataUtil.getCustomerInfo();
        String fullname = "${user.firstname} ${user.lastname}";

        bool isNewRegister = ShareDataUtil.getNewRegister();

        if (isNewRegister) {
          //Group Chat
          await Future.delayed(Duration(milliseconds: 100));
          await ClearCountNotificationUtil.chat(AppData.groupChatChatMasterId);

          //Single Chat
          ResultData chatResultData = await ChatImpService().getChatList(
            userId: ShareDataUtil.getUserId(),
            typeAccount: AppData.singleChatTypeAccount,
            customerId: customerInfo.customerId,
            authenKey: ShareDataUtil.getAuthenKey(),
          );

          if (!AppUtil.isNil(chatResultData.result)) {
            List<ChatRoomModel> chatRoomList = chatResultData.result;
            chatRoomList.map((item) async {
              if (!AppUtil.isNil(item.chatMasterId)) {
                await Future.delayed(Duration(milliseconds: 100));
                await ClearCountNotificationUtil.chat(item.chatMasterId);
              }
            }).toList();
          }

          //Clear noti
          await Future.delayed(Duration(milliseconds: 100));
          await ClearCountNotificationUtil.additionalService();
          await Future.delayed(Duration(milliseconds: 100));
          await ClearCountNotificationUtil.reportIncident();
          await Future.delayed(Duration(milliseconds: 100));
          await ClearCountNotificationUtil.news();
          await Future.delayed(Duration(milliseconds: 100));
          await ClearCountNotificationUtil.activity();
          await Future.delayed(Duration(milliseconds: 100));
          await ClearCountNotificationUtil.timeline();
          await ShareDataUtil.setNewRegister(false);
        }

        yield HomeAppBarLoaded(result: fullname);
      }
    } catch (e) {
      yield HomeAppBarError(message: "Error");
    }
  }
}
