import 'dart:async';

import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:equatable/equatable.dart';
import 'package:peasmartcare/models/history_bill_detail_model.dart';
import 'package:peasmartcare/models/result_data_model.dart';
import 'package:peasmartcare/services/history_bill_service.dart';

part 'history_bill_detail_list_event.dart';
part 'history_bill_detail_list_state.dart';

class HistoryBillDetailListBloc extends Bloc<HistoryBillDetailListEvent, HistoryBillDetailListState> {
  HistoryBillImpService service = HistoryBillImpService();

  ResultData resultData;
  List<HistoryBillDetailModel> _historyBillList;

  HistoryBillDetailListBloc() : super(HistoryBillDetailListInitial());

  @override
  Stream<HistoryBillDetailListState> mapEventToState(HistoryBillDetailListEvent event) async* {
    try {
      if (event is HistoryBillDetailListGetList) {
        yield HistoryBillDetailListLoading();

        // resultData = await service.getDetailList(
        //   authenKey: ShareDataUtil.getAuthenKey(),
        //   billId: _billId,
        // );

        //  = resultData.result;

        yield HistoryBillDetailListLoaded(result: _historyBillList, deleteSuccess: null);
      } else if (event is HistoryBillDetailListAddDetail) {
        _historyBillList = event.details;
      }
    } catch (e) {
      yield HistoryBillDetailListError(message: "Error");
    }
  }
}
