part of 'feedback_type_bloc.dart';

abstract class FeedbackTypeState extends Equatable {
  const FeedbackTypeState();
  @override
  List<Object> get props => [];
}

class FeedbackTypeInitial extends FeedbackTypeState {
  @override
  List<Object> get props => [];
}

class FeedbackTypeLoading extends FeedbackTypeState {}

class FeedbackTypeLoaded extends FeedbackTypeState {
  final List<FeedbackTypeModel> result;

  FeedbackTypeLoaded({
    this.result,
  });
  @override
  List<Object> get props => [result];
}

class FeedbackTypeNotFound extends FeedbackTypeState {}

class FeedbackTypeError extends FeedbackTypeState {
  final String message;
  const FeedbackTypeError({this.message});
  @override
  List<Object> get props => [message];
}

class FeedbackTypeErrorUnauthorized extends FeedbackTypeState {}
