part of 'feedback_province_bloc.dart';

abstract class FeedbackProvinceState extends Equatable {
  const FeedbackProvinceState();
  @override
  List<Object> get props => [];
}

class FeedbackProvinceInitial extends FeedbackProvinceState {
  @override
  List<Object> get props => [];
}

class FeedbackProvinceLoading extends FeedbackProvinceState {}

class FeedbackProvinceLoaded extends FeedbackProvinceState {
  final List<FeedbackProvinceModel> resultProvince;
  final List<FeedbackBranchModel> resultBranch;

  FeedbackProvinceLoaded({this.resultProvince, this.resultBranch});
  @override
  List<Object> get props => [resultProvince, resultBranch];
}

class FeedbackProvinceNotFound extends FeedbackProvinceState {}

class FeedbackProvinceError extends FeedbackProvinceState {
  final String message;
  const FeedbackProvinceError({this.message});
  @override
  List<Object> get props => [message];
}

class FeedbackProvinceErrorUnauthorized extends FeedbackProvinceState {}
