import 'dart:async';

import 'package:bloc/bloc.dart';
import 'package:equatable/equatable.dart';
import 'package:peasmartcare/models/electricity_statistic_pea_number_model.dart';
import 'package:peasmartcare/models/result_data_model.dart';
import 'package:peasmartcare/services/electricity_statistic_service.dart';
import 'package:peasmartcare/utils/share_data_util.dart';

part 'electricity_statistic_pea_number_list_event.dart';
part 'electricity_statistic_pea_number_list_state.dart';

class ElectricityStatisticPeaNumberListBloc extends Bloc<ElectricityStatisticPeaNumberListEvent, ElectricityStatisticPeaNumberListState> {
  ElectricityStatisticImpService service = ElectricityStatisticImpService();

  ResultData resultData;

  ElectricityStatisticPeaNumberListBloc() : super(ElectricityStatisticPeaNumberListInitial());

  @override
  Stream<ElectricityStatisticPeaNumberListState> mapEventToState(ElectricityStatisticPeaNumberListEvent event) async* {
    try {
      if (event is ElectricityStatisticPeaNumberListGetList) {
        yield ElectricityStatisticPeaNumberListLoading();
        resultData = await service.getStatisticPeaNumberList(
          caNumber: ShareDataUtil.getCaNumber(),
          authenKey: ShareDataUtil.getAuthenKey(),
        );

        if (resultData.statusCode == 401) {
          yield ElectricityStatisticPeaNumberListErrorUnauthorized();
        } else {
          yield ElectricityStatisticPeaNumberListLoaded(result: resultData.result);
        }
      }
    } catch (e) {
      yield ElectricityStatisticPeaNumberListError(message: "Error");
    }
  }
}
