import 'dart:async';

import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:equatable/equatable.dart';
import 'package:peasmartcare/models/electricity_location_customer_model.dart';
import 'package:peasmartcare/models/result_data_model.dart';
import 'package:peasmartcare/services/electricity_location_service.dart';
import 'package:peasmartcare/utils/share_data_util.dart';

part 'electricity_location_list_event.dart';
part 'electricity_location_list_state.dart';

class ElectricityLocationListBloc extends Bloc<ElectricityLocationListEvent, ElectricityLocationListState> {
  ElectricityLocationImpService service = ElectricityLocationImpService();

  ResultData resultData;

  ElectricityLocationListBloc() : super(ElectricityLocationListInitial());

  @override
  Stream<ElectricityLocationListState> mapEventToState(ElectricityLocationListEvent event) async* {
    try {
      if (event is ElectricityLocationListGetList) {
        yield ElectricityLocationListLoading();

        resultData = await service.getList(
          idCard: ShareDataUtil.getIdCard(),
          authenKey: ShareDataUtil.getAuthenKey(),
        );

        if (resultData.statusCode == 401) {
          yield ElectricityLocationListErrorUnauthorized();
        } else {
          yield ElectricityLocationListLoaded(result: resultData.result);
        }
      }
    } catch (e) {
      yield ElectricityLocationListError(message: "Error");
    }
  }
}
