part of 'electricity_location_current_bloc.dart';

abstract class ElectricityLocationCurrentState extends Equatable {
  const ElectricityLocationCurrentState();

  @override
  List<Object> get props => [];
}

class ElectricityLocationCurrentInitial extends ElectricityLocationCurrentState {}

class ElectricityLocationCurrentLoading extends ElectricityLocationCurrentState {}

class ElectricityLocationCurrentLoaded extends ElectricityLocationCurrentState {
  final ElectricityLocationLatLongModel result;

  ElectricityLocationCurrentLoaded({
    this.result,
  });
  @override
  List<Object> get props => [result];
}

class ElectricityLocationCurrentNotFound extends ElectricityLocationCurrentState {}

class ElectricityLocationCurrentError extends ElectricityLocationCurrentState {
  final String message;
  const ElectricityLocationCurrentError({this.message});
  @override
  List<Object> get props => [message];
}

class ElectricityLocationCurrentErrorUnauthorized extends ElectricityLocationCurrentState {}
