import 'dart:async';

import 'package:bloc/bloc.dart';
import 'package:equatable/equatable.dart';
import 'package:peasmartcare/models/electricity_location_lat_long_model.dart';
import 'package:peasmartcare/models/result_data_model.dart';
import 'package:peasmartcare/services/electricity_location_service.dart';
import 'package:peasmartcare/utils/share_data_util.dart';

part 'electricity_location_current_event.dart';
part 'electricity_location_current_state.dart';

class ElectricityLocationCurrentBloc extends Bloc<ElectricityLocationCurrentEvent, ElectricityLocationCurrentState> {
  ElectricityLocationImpService service = ElectricityLocationImpService();

  ResultData resultData;

  ElectricityLocationCurrentBloc() : super(ElectricityLocationCurrentInitial());

  @override
  Stream<ElectricityLocationCurrentState> mapEventToState(ElectricityLocationCurrentEvent event) async* {
    try {
      if (event is ElectricityLocationCurrentGetCurrent) {
        yield ElectricityLocationCurrentLoading();

        resultData = await service.getCurrentLocation(
          customerId: ShareDataUtil.getCustomerId(),
          authenKey: ShareDataUtil.getAuthenKey(),
        );

        if (resultData.statusCode == 401) {
          yield ElectricityLocationCurrentErrorUnauthorized();
        } else {
          yield ElectricityLocationCurrentLoaded(result: resultData.result);
        }
      }
    } catch (e) {
      yield ElectricityLocationCurrentError(message: "Error");
    }
  }
}
