part of 'customer_info_bloc.dart';


abstract class CustomerInfoState extends Equatable {
  const CustomerInfoState();

  @override
  List<Object> get props => [];
}

class CustomerInfoInitial extends CustomerInfoState {
  @override
  List<Object> get props => [];
}

class CustomerInfoLoading extends CustomerInfoState {}

class CustomerInfoLoaded extends CustomerInfoState {
  final CustomerInfoModel result;

  CustomerInfoLoaded({
    this.result,
  });
  @override
  List<Object> get props => [result];
}

class CustomerInfoNotFound extends CustomerInfoState {}

class CustomerInfoError extends CustomerInfoState {
  final String message;
  const CustomerInfoError({this.message});
  @override
  List<Object> get props => [message];
}
