import 'dart:async';

import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:equatable/equatable.dart';
import 'package:peasmartcare/models/coordinator_model.dart';
import 'package:peasmartcare/models/coordinator_position_model.dart';
import 'package:peasmartcare/models/result_data_model.dart';
import 'package:peasmartcare/services/coordinator_service.dart';
import 'package:peasmartcare/utils/share_data_util.dart';

part 'coordinator_save_event.dart';
part 'coordinator_save_state.dart';

class CoordinatorSaveBloc extends Bloc<CoordinatorSaveEvent, CoordinatorSaveState> {
  CoordinatorImpService service = CoordinatorImpService();

  // ResultData resultData;
  CoordinatorModel coordinator;
  List<CoordinatorPositionModel> positionList = [];

  CoordinatorSaveBloc() : super(CoordinatorSaveInitial());

  @override
  Stream<CoordinatorSaveState> mapEventToState(CoordinatorSaveEvent event) async* {
    try {
      if (event is CoordinatorSaveGetData) {
        coordinator = event.coordinator;
        yield CoordinatorSaveLoading();

        CoordinatorModel result;

        if (coordinator.id != null) {
          result = coordinator;
        } else {
          result = CoordinatorModel();
        }

        // resultData.result = result;

        ResultData positionResultData = await service.getPositionList();

        positionList = positionResultData.result;

        if (positionResultData.statusCode == 401) {
          yield CoordinatorSaveErrorUnauthorized();
        } else {
          yield CoordinatorSaveLoaded(result: result, positionList: positionList, saveSuccess: null);
        }
      } else if (event is CoordinatorSaveOnSubmit) {
        yield CoordinatorSaveLoading();
        String id = event.id;
        String fullname = event.fullname;
        String position = event.position;
        String phone = event.phone;
        String idCard = event.idCard;
        String otherContact = event?.otherContact;

        ResultData saveResult;
        CoordinatorModel result;

        if (!event.isCreate) {
          saveResult = await service.update(
            id: id,
            customerId: ShareDataUtil.getCustomerId(),
            fullname: fullname,
            position: position,
            phone: phone,
            idCard: idCard,
            otherContact: otherContact,
            authenKey: ShareDataUtil.getAuthenKey(),
          );

          // result = resultData.result;
        } else {
          saveResult = await service.create(
            customerId: ShareDataUtil.getCustomerId(),
            fullname: fullname,
            position: position,
            phone: phone,
            idCard: idCard,
            otherContact: otherContact,
            authenKey: ShareDataUtil.getAuthenKey(),
          );

          result = CoordinatorModel();
        }
        // yield CoordinatorSaveLoaded(result: result, positionList: positionList, saveSuccess: saveResult.result, errorMessage: saveResult.statusMessage);

        if (saveResult.statusCode == 401) {
          yield CoordinatorSaveErrorUnauthorized();
        } else {
          yield CoordinatorSaveLoaded(result: result, positionList: positionList, saveSuccess: saveResult.result, errorMessage: "มีผู้แทนบริษัทที่ใช้เลขบัตรประชาชนนี้อยู่แล้วในระบบ");
        }
      }
    } catch (e) {
      yield CoordinatorSaveError(message: "Error");
    }
  }
}
