part of 'contact_staff_list_bloc.dart';

abstract class ContactStaffListState extends Equatable {
  const ContactStaffListState();

  @override
  List<Object> get props => [];
}

class ContactStaffListInitial extends ContactStaffListState {
  @override
  List<Object> get props => [];
}

class ContactStaffListLoading extends ContactStaffListState {}

class ContactStaffListLoaded extends ContactStaffListState {
  final List<ContactStaffModel> result;

  ContactStaffListLoaded({
    this.result,
  });
  @override
  List<Object> get props => [result];
}

class ContactStaffListNotFound extends ContactStaffListState {}

class ContactStaffListError extends ContactStaffListState {
  final String message;
  const ContactStaffListError({this.message});
  @override
  List<Object> get props => [message];
}

class ContactStaffListErrorUnauthorized extends ContactStaffListState {}
