import 'dart:async';

import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:equatable/equatable.dart';
import 'package:peasmartcare/models/contact_staff_model.dart';
import 'package:peasmartcare/models/result_data_model.dart';
import 'package:peasmartcare/services/contact_staff_service.dart';
import 'package:peasmartcare/utils/share_data_util.dart';

part 'contact_staff_list_event.dart';
part 'contact_staff_list_state.dart';

class ContactStaffListBloc extends Bloc<ContactStaffListEvent, ContactStaffListState> {
  ContactStaffImpService service = ContactStaffImpService();

  ResultData resultData;
  // List<ContactStaffModel> contactStaffList;

  ContactStaffListBloc() : super(ContactStaffListInitial());

  @override
  Stream<ContactStaffListState> mapEventToState(ContactStaffListEvent event) async* {
    try {
      if (event is ContactStaffListGetList) {
        yield ContactStaffListLoading();
        resultData = await service.getList(
          customerId: ShareDataUtil.getCustomerId(),
          authenKey: ShareDataUtil.getAuthenKey(),
        );

        if (resultData.statusCode == 401) {
          yield ContactStaffListErrorUnauthorized();
        } else {
          yield ContactStaffListLoaded(result: resultData.result);
        }
      }
    } catch (e) {
      yield ContactStaffListError(message: "Error");
    }
  }
}
